*openUBMC openUBMC 支持设置SSD盘寿命过低告警阈值详细设计说明书*

<table>
    <tr>
        <td>所属SIG组:</td>
        <td>hardware</td>
    </tr>
    <tr>
        <td>落入版本:</td>
        <td>25.12</td>
    </tr>
    <tr>
        <td>设计人员:</td>
        <td>黄明浩</td>
    </tr>
    <tr>
        <td>日期:</td>
        <td>2025/11/24</td>
    </tr>
</table>


**Copyright © 2025 openUBMC Community**

您对&quot;本文档&quot;的复制，使用，修改及分发受木兰宽松许可证, 第2版协议(以下简称&quot;MulanPSL2&quot;)的约束。
为了方便用户理解，您可以通过访问<https://license.coscl.org.cn/MulanPSL2>了解MulanPSL2的概要 (但不是替代)。
MulanPSL2的完整协议内容您可以访问如下网址获取：<https://license.coscl.org.cn/MulanPSL2>。

**改版记录**

<table>
    <tr>
        <th>日期</th>
        <th>修订版本</th>
        <th>修订描述</th>
        <th>作者</th>
        <th>审核</th>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
</table>

**List of abbreviations**  **缩略语清单** ：

<table>
    <tr>
        <th>Abbreviations 缩略语</th>
        <th>Full spelling 英文全名</th>
        <th>Chinese explanation 中文解释</th>
    </tr>
    <tr>
        <td></td>
        <td></td>
        <td></td>
    </tr>
</table>

[TOC]

# 1.功能分析
## 1.1 功能背景
<!-- 描述该需求的来源或背景，比如：支撑XXX功能、XXX优化等；以及该需求对用户（含组件）带来什么具体价值，如果没有该需求，对用户（含组件）带来什么损失； -->
该需求用来支持设置SSD盘寿命过低告警阈值，可以通过北向接口如redfish和web查看和设置SSD盘寿命过低告警阈值，满足客户灵活设置SSD盘寿命过低告警的阈值的诉求。

## 1.2 功能描述
<!-- 描述该需求交付的整体功能，主要实现XXX功能，解决XXX问题，明确方案如何实现 -->
实现SSD盘寿命过低告警可配置的功能，解决目前SSD盘寿命过低告警阈值固定为5，不可灵活配置，满足客户要求的问题。</br>
1.在新增对象StorageSetting中（path:“/bmc/kepler/Chassis/:Chassisid/Storage”,interface:“bmc.kepler.Chassis.Storage.StorageSetting”）中新增属性SSDMediaLifeLeftPercentThreshold </br>

| 属性名称 | 变化类型 | 签名 | 读写&权限 | 持久化 | 变化通知 | 属性说明 | 接口约束 |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| SSDMediaLifeLeftPercentThreshold | 新增属性 | y | R:ReadOnly<br>W:DiagnoseMgmt | 掉电持久化 | 是 | 硬盘剩余磨损率告警阈值，单位（%）<br>取值范围：1~50；<br>默认值：5 | 无 |

2.该属性有写权限，有DiagnoseMgmt权限的用户可以直接修改该属性 </br>
3.StorageSetting对象配置在platform.sr中，为全局对象，可以在硬盘背板SR中，修改EventKeyId为DiskRemMediaWearoutLow的告警的阈值Condition和DescArg4，分别配置为同步语法和引用语法。</br>
4.北向接口修改如下:</br>
redfish：</br>
URI:“/redfish/v1/Systems/:systemid”（已有）</br>
变化类型：新增Oem属性</br>
操作类型：GET/Patch</br>
应用场景：用于获取剩余寿命过低告警阈值</br>
| 属性名称 | 操作权限 | 取值类型 | 取值范围 | 默认值 | 说明 | 约束 |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| SSDMediaLifeLeftPercentThreshold | ReadOnly | integer | 1~50 | 5 | 硬盘剩余磨损率告警门限，单位（%） | 无 |

URI:“/redfish/v1/Chassis/:chassisid”（已有）</br>
变化类型：新增Oem属性</br>
操作类型：GET/Patch</br>
应用场景：用于获取剩余寿命过低告警阈值</br>
| 属性名称 | 操作权限 | 取值类型 | 取值范围 | 默认值 | 说明 | 约束 |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| SSDMediaLifeLeftPercentThreshold | ReadOnly | integer | 1~50 | 5 | 硬盘剩余磨损率告警门限，单位（%） | 无 |

web：</br>
URI: “/UI/Rest/System/Storage/Settings”（新增）</br>
变化类型：新增URI,新增属性</br>
操作类型：GET/Patch</br>
| 属性名称 | 操作权限 | 取值类型 | 取值范围 | 默认值 | 说明 | 约束 |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| SSDMediaLifeLeftPercentThreshold | ReadOnly | integer | 1~50 | 5 | 硬盘剩余磨损率告警门限，单位（%） | 无 |

## 1.3 功能场景
1) 场景触发条件及对象：网管、运维人员、开发人员可以通过web或其他接口查看获取NVMe盘的信息
2) 使用时间及频度：不频繁

## 1.4 功能列表
<!-- 描述该需求交付的功能列表，内容包括：列出功能详细描述，标题、描述。 -->
| 功能编号 | 功能标题 | 功能描述 |
| ------- | ------- | -------- |
| 1 | 支持设置SSD盘寿命过低告警阈值 | 支持设置SSD盘寿命过低告警阈值 |

# 2.功能设计
## 2.1 总体方案分析
<!-- 描述该方案的总体设计（注：相关输出方案可同步刷新到各组件仓） -->
1.redfish接口</br>
schema说明：
```
"SSDMediaLifeLeftPercentThreshold": {
    "$ref": "#/definitions/ThresholdValue",
    "readonly": false,
    "description": "Indicates the maximum threshold (%) of the ssd wornout.",
    "longDescription": "Indicates the maximum threshold (%) of the ssd wornout"
}
```
示例：
```
{
 "Oem": {
        "openUBMC": {
             "SSDMediaLifeLeftPercentThreshold": 5
         }
   }
}
```
2.web接口</br>
URI: “/UI/Rest/System/Storage/Settings”（新增）</br>
变化类型：新增URI,新增属性,方法GET/PATCH</br>
示例：
```
{
    "SSDMediaLifeLeftPercentThreshold": 5
}
```



### 2.1.1 方案详细设计
#### 2.1.1.1 方案概述
<!-- 描述该方案的整体实现，内容包括：涉及的关键点，实现策略等 -->

不再赘述，如1.2节所述有两点注意点：</br>
1.SSDMediaLifeLeftPercentThreshold在model.json中配置"defualt": 5</br>
2.告警对象中配置"@Default": {"Condition": 5}</br>
第一点配置不需要在platform.sr中再增加该属性</br>
第二点保证老BMC，新硬盘背板sr中阈值也为5</br>

#### 2.1.1.2 开发视图
<!-- 开发视图面向系统开发及软件管理，描述系统代码结构，构建结构的视图，主要解决系统技术实现和开发的问题，它依托逻辑视图，描述代码、构建结构 -->
```mermaid
classDiagram
    class rackmount {
        +setSSDMediaLifeLeftPercentThreshold(value: U8)
        -validateRange(value: int): boolean
    }

    class Mapper {
        +Source: ResourceInterface
    }

    class ResourceInterface {
        +updateThreshold(value: int)
        +syncEventCondition()
    }

    class Event_DiskRemMediaWearoutLow {
        +evaluate(currentWear: int): bool
        +triggerAlert()
    }

    class EventComponent {
        +registerEvent(event: Event_DiskRemMediaWearoutLow)
        +checkAllEvents()
    }

    rackmount --> Mapper : 调用
    Mapper --> ResourceInterface : 写入并同步
    ResourceInterface --> Event_DiskRemMediaWearoutLow : 更新条件
    EventComponent --> Event_DiskRemMediaWearoutLow : 监控和触发
```

#### 2.1.1.3 运行视图
<!-- 运行视图面向系统运行，描述系统启动过程、运行期交互的视图，主要解决系统运行期交互，描述各可执行交付件在运行期的交互关系 -->
```mermaid
sequenceDiagram
    autonumber
    actor User as 用户/北向客户端
    participant NB as NorthBoundInterface
    participant MAP as Mapper
    participant RES as DBus资源树<br/>ResourceInterface
    participant EVT_MGR as EventComponent
    participant EVT as Event_DiskRemMediaWearoutLow

    title SSD 剩余寿命告警阈值设置与事件触发流程（基于 DBus 资源树）

    Note over User,RES: 设置阈值后，Event组件监听资源树属性变化并动态判断告警状态

    User->>NB: setSSDMediaLifeLeftPercentThreshold(5)
    activate NB

    NB->>MAP: mapAndSetThreshold(5)
    activate MAP

    MAP->>RES: SetProperty(SSDMediaLifeLeftPercentThreshold, 5)
    activate RES
    RES-->>MAP: ACK
    deactivate RES
    MAP-->>NB: Success
    deactivate MAP

    NB-->>User: 200 OK
    deactivate NB

    RES->>EVT: SetCondition(threshold=5)
    activate EVT
    EVT-->>RES: ConditionUpdated & Broadcast
    deactivate EVT

    EVT_MGR->>EVT: SubscribeToProperties("Condition", "Reading")
    activate EVT_MGR
    EVT_MGR-->>EVT: Listening...
    deactivate EVT_MGR

    Note right of EVT: 监听 Condition 和 Reading 属性变化

    RES->>EVT: PropertiesChanged(Condition=5, Reading=3)
    activate EVT
    EVT-->>RES: ACK

    EVT->>EVT_MGR: evaluate(currentReading=3, threshold=5)
    activate EVT_MGR

    alt 当前剩余磨损率 <= 阈值（满足告警）
        EVT_MGR->>EVT_MGR: triggerAlert("DiskRemMediaWearoutLow")
        Note right of EVT_MGR: 生成告警事件
    else 当前剩余磨损率 > 阈值（不满足告警）
        EVT_MGR->>EVT_MGR: clearOrSuppressAlert()
        Note right of EVT_MGR: 消除或抑制告警
    end

    deactivate EVT_MGR
    deactivate EVT
```

### 2.1.2 内部依赖分析
<!-- 是否涉及与其他组件接口依赖，如果涉及需要确认当前是否已完成，是否匹配当前需求开发诉求 -->
不涉及内部依赖

### 2.1.3 外部依赖分析
<!-- 是否涉及与平台SDK的依赖关系 -->
仅需将告警对象的Condition通过同步语法关联StorageSetting.SSDMediaLifeLeftPercentThreshold,
StorageSetting对象配在platform.sr中，为全局对象，可以跨csr关联。</br>
依赖Event组件监听Reading和Condition的变化</br>

### 2.1.4 北向接口分析
<!-- 需要分析当前功能是否有以下接口影响，如果有影响，则需要具体的补充影响点。其中注意点如下：
（1）如果有新增IPMI接口，请排查代码中IPMI命令注册的过滤字段，是否完全和IPMI命令的定义一致？
（2）新增一个接口时，需要咨询SIG组是否还有其他的接口受影响 -->
| 特性 | SNMP | CLI | WEB | KVM_VMM | IPMI(RMCP/RMCP+) | HMM | Redfish |
| ---- | ---- | ---- | --- | ------ | ---------------- | --- | ------- |
| 支持设置SSD盘寿命过低告警阈值 | 不涉及 | 不涉及 | 新增uri | 不涉及 | 不涉及 | 不涉及 | 原有uri新增属性 |

### 2.1.5 兼容性分析
<!-- 当前的功能对现有在网的功能是否有影响，具体的影响点进行分析之后输出影响分析表格 -->
1.新BMC，Eeprom里为老硬盘背板CSR，实际生效的为新BMC里内置的新硬盘背板CSR，支持设置阈值。</br>
2.老BMC，Eeprom里新硬盘背板csr，实际生效的为Eeprom的新硬盘背板CSR，但由于老BMC无该阈值属性，同步语法失效，</br>
使用@Default中的阈值5，兼容已有功能，不支持设置阈值。</br>
新BMC,新硬盘背板CSR和老BMC和老硬盘背板CSR无问题。

### 2.1.6 定制化接口分析
不涉及
### 2.1.7 导入导出分析
<!-- 如果支持导入导出的配置，则需要分析导入导出的schema。 -->
不涉及
### 2.1.8 传感器分析
<!-- 如果需要新增传感器，则需要提前登记和评审新增的传感器要素。新增传感器评审需要上SIG-Interface进行评审 -->
不涉及
### 2.1.9 精准告警事件分析
<!-- 如果需要新增事件，则需要提前登记和评审新增的时间要素 -->
无新增告警事件，需按需求描述修改告警描述。
### 2.1.10 系统锁定分析
<!-- 对外的接口或者命令是否支持系统锁定 -->
不涉及
### 2.1.11 用例场景分析
<!-- 以表格的形式输出该需求涉及的用例场景 -->
| 用例编号 | 用例描述 | 前置条件 |执行步骤 | 预期结果 |
| --- | --- | --- | --- | --- |
| 1 | redifsh接口查询该阈值 | 无 | 1.redfish通过指定uri发送Get请求 | 数据与资源树上的一致 |
| 2 | web接口查询该阈值 | 无 | 1.web通过指定uri发送Get请求 | 数据与资源树上的一致 |
| 3 | redfish接口设置该阈值 | 无 | 1.redfish通过指定uri发送Patch请求；2.redfish通过指定uri发送Get请求； | 1.Patch成功 2.Get的结果与Patch一致|
| 4 | web接口设置该阈值 | 无 | 1.web设置阈值；2.web查询阈值； | 1.设置成功 2.Get的结果与Patch一致|
| 5 | 北向接口设置该阈值大于等于硬盘磨损率 | 无 | 1.web设置阈值；2.查看告警； | 1.设置成功 2.低于阈值的硬盘产生告警|
| 6 | 北向接口设置该阈值小于硬盘磨损率 | 无 | 1.web设置阈值；2.查看告警； | 1.设置成功 2.无告警|
| 7 | 北向接口设置该阈值超过允许范围 | 无 | 1.web设置阈值 | 1.返回失败 2.无告警|
| 8 | 北向接口非调试诊断权限的用户设置该阈值超过允许范围 | 无 | 1.web设置阈值 | 1.返回权限失败 2.无告警|

## 2.2 非功能质量属性设计
### 2.2.1 扩展性分析
<!-- 考虑后续新增类似功能可以很好地扩展 -->
不涉及

### 2.2.2 重用性分析
<!-- 是否为通用处理方式、接口，如果是得考虑重用性 -->
不涉及

### 2.2.3 可测试性分析
<!-- 此需求如何验证，是否可直接验证，or通过XXX功能覆盖验证，or需要单独怎加测试接口验证 -->
可以通过mdbctl设置硬盘当前的剩余磨损率,结合设置告警阈值，模拟产生和恢复告警。

### 2.2.4 资料分析
<!-- 是否涉及资料修改 -->
涉及，需要修改redfish资料（schema）和web联机帮助，webreset资料

### 2.2.5 资源使用分析
<!-- 新增线程、内存分配、模型属性名长度是否合理，CPU占用率是否会激增，Flash中新增文件是否合理（频繁读写Flash会大幅缩短emmc寿命）；是否涉及消息队列，如果涉及请检查是否存在某些场景下消息队列会满导致消息丢失，例如大量消息发送到队列且处理消息需要耗费较长时间的场景。 -->
不涉及
### 2.2.6 可靠性分析
storage组件里监听该属性变化并记录操作日志。（无法记录设置失败的操作日志）
| 编号 | 场景 | 问题描述 | 可靠性影响 | 建议解决方案/需求 | 备注 |
| --- | --- | --- | --- | --- | --- |
| 1 | BMC复位场景 | 验证复位后阈值是否会改变 | 掉电持久化生效，阈值不变 | 无影响 | - |
| 2 | AC场景 | 验证AC后阈值是否会改变 | 掉电持久化生效，阈值不变 | 无影响 | - |
| 3 | 无调试诊断权限的用户设置该权限 | 无权限用户 | 设置失败，返回权限不足 | 无影响 | - |
| 4 | 老BMC升级新硬盘背板csr | 同步语法失效 | 通过@Default使用固定阈值5 | 无影响 | - |
| 5 | 新BMC升级老硬盘背板CSR | 硬盘背板Eeprom的CSR降级 | 由于新BMC中内置的硬盘背板CSR版本高于Eeprom中的老CSR，</br>实际生效的仍是新CSR | 无影响 | - |
| 6 | 新BMC降级 | BMC降级 | 如果Eeprom中的CSR为新的，则按照@Default的阈值5生效，并且不支持设置阈值。</br> 反之，为老BMC+老CSR | 无影响 | - |
| 7 | 老BMC升级 | BMC升级 | 支持设置阈值，并且告警以设置的阈值作为Condition | 无影响 | - |

### 2.2.7 安全性分析
| 安全合规项 | 是否涉及 | 现有的防护措施 |
| --- | --- | --- |
| 访问控制（通道、文件权限、用户权限、查询权限、配置权限、接口权限） | 设置时权限调试诊断 |  |
| 敏感数据 | 不涉及 |  |
| 日志（操作日志、维护日志、安全日志、运行日志） | 设置时打印对应的操作日志 |  |
| 文档 | 不涉及 |  |
| 加密及算法 | 不涉及 |                      |
| 新增关键资源（密钥、证书、关键配置）备份、恢复 | 不涉及 |  |
| 新增对外接口入参校验 | 不涉及 |  |
| 新增开源及三方软件引入 | 不涉及 |  |
# 3.功能实现
<!-- 通过表格、流程图、简明文字描述提供，力求容易看懂、容易实现，详细描述细节。 -->
## 3.支持设置SSD盘寿命过低告警阈值
### 3.1.1 功能实现设计
见2.1 总体方案分析，不再赘述

### 3.1.2 功能详细设计
如 2.1 章节所示
### 3.1.3 开发者测试
<!--
增加模块接口：以活动图/流程图等形式明确模块内处理流程，针对模块处理流程中的分支进行覆盖
修改模块接口处理流程：覆盖修改影响流程分支
-->
#### 3.1.3.1 单元测试
<!-- UT，主要是功能单元测试，测试对象是功能单元接口。UT测试设计要从黑盒（功能）角度设计，从输入(I)、处理（B）、预期输出（O）的角度进行用例分析设计，测试覆盖率仅作为反馈，用于分析哪些功能场景没有覆盖到，从而指导测试设计优化并补充测试用例 -->
storage仓除了自动生成，无代码修改，其余映射器配置在rackmount仓，无需UT。

#### 3.1.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->
不涉及